/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.util;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.sf.eclipsecs.core.Messages;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class EclipseLogHandler
extends Handler {
    private final String mPluginID;
    private final ILog mPluginLog;

    public EclipseLogHandler(Plugin loggingPlugin) {
        this.mPluginLog = loggingPlugin.getLog();
        this.mPluginID = loggingPlugin.getBundle().getSymbolicName();
    }

    @Override
    public void publish(LogRecord record) {
        int severity = 0;
        Level level = record.getLevel();
        if (Level.CONFIG.equals(level) || Level.INFO.equals(level) || Level.FINE.equals(level) || Level.FINER.equals(level) || Level.FINEST.equals(level)) {
            severity = 1;
        } else if (Level.WARNING.equals(level)) {
            severity = 2;
        } else if (Level.SEVERE.equals(level)) {
            severity = 4;
        }
        String message = record.getMessage();
        Throwable thrown = record.getThrown();
        Status status = new Status(severity, this.mPluginID, 0, NLS.bind((String)Messages.CheckstyleLog_msgStatusPrefix, (Object)message), thrown);
        this.mPluginLog.log((IStatus)status);
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }
}

