/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess.providers;

import java.util.Objects;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.keys.BindingService;
import org.eclipse.ui.internal.menus.CommandMessages;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.quickaccess.providers.CommandProvider;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.quickaccess.QuickAccessElement;

public class CommandElement
extends QuickAccessElement {
    private ParameterizedCommand command;
    private String id;
    private CommandProvider provider;

    CommandElement(ParameterizedCommand command, String id, CommandProvider commandProvider) {
        this.provider = commandProvider;
        this.id = id;
        this.command = command;
    }

    @Override
    public void execute() {
        if (this.provider != null && this.provider.getHandlerService() != null && this.provider.getEvaluationContext() != null) {
            try {
                this.provider.getHandlerService().executeCommandInContext(this.command, null, this.provider.getEvaluationContext());
            }
            catch (Exception ex) {
                StatusUtil.handleStatus(ex, 3);
            }
            return;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            IHandlerService handlerService = (IHandlerService)window.getWorkbench().getService(IHandlerService.class);
            try {
                handlerService.executeCommand(this.command, null);
            }
            catch (Exception ex) {
                StatusUtil.handleStatus(ex, 3);
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        ICommandImageService imgService = this.provider.getCommandImageService();
        return imgService == null ? null : imgService.getImageDescriptor(this.getId());
    }

    public String getCommand() {
        StringBuilder label = new StringBuilder();
        try {
            Command nestedCommand = this.command.getCommand();
            label.append(this.command.getName());
            if (nestedCommand != null && nestedCommand.getDescription() != null && nestedCommand.getDescription().length() != 0) {
                label.append(" - ").append(nestedCommand.getDescription());
            }
        }
        catch (NotDefinedException notDefinedException) {
            label.append(this.command.toString());
        }
        return label.toString();
    }

    @Override
    public String getLabel() {
        String command = this.getCommand();
        String binding = this.getBinding();
        if (binding != null) {
            return NLS.bind((String)CommandMessages.Tooltip_Accelerator, (Object)command, (Object)binding);
        }
        return command;
    }

    public String getBinding() {
        BindingService service = (BindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        TriggerSequence[] triggerSeq = service.getBindingManager().getActiveBindingsDisregardingContextFor(this.command);
        if (triggerSeq != null && triggerSeq.length > 0) {
            return triggerSeq[0].format();
        }
        return null;
    }

    @Override
    public String getSortLabel() {
        try {
            return this.command.getName();
        }
        catch (NotDefinedException notDefinedException) {
            return this.command.toString();
        }
    }

    @Override
    public String getMatchLabel() {
        String defaultMatchLabel = super.getMatchLabel();
        try {
            return String.valueOf(defaultMatchLabel) + ' ' + this.command.getCommand().getCategory().getName();
        }
        catch (NotDefinedException notDefinedException) {
            return defaultMatchLabel;
        }
    }

    public int hashCode() {
        return Objects.hashCode(this.command);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommandElement other = (CommandElement)obj;
        return Objects.equals(this.command, other.command);
    }
}

