/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.rule;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.oniguruma.OnigCaptureIndex;
import org.eclipse.tm4e.core.internal.rule.CompiledRule;
import org.eclipse.tm4e.core.internal.rule.IRuleRegistry;
import org.eclipse.tm4e.core.internal.rule.RegExpSourceList;
import org.eclipse.tm4e.core.internal.rule.RuleId;
import org.eclipse.tm4e.core.internal.utils.RegexSource;

public abstract class Rule {
    final RuleId id;
    private final @Nullable String name;
    private final boolean nameIsCapturing;
    private final @Nullable String contentName;
    private final boolean contentNameIsCapturing;

    Rule(RuleId id, @Nullable String name, @Nullable String contentName) {
        this.id = id;
        this.name = name;
        this.nameIsCapturing = RegexSource.hasCaptures(name);
        this.contentName = contentName;
        this.contentNameIsCapturing = RegexSource.hasCaptures(contentName);
    }

    public @Nullable String getName(@Nullable CharSequence lineText, OnigCaptureIndex @Nullable [] captureIndices) {
        String name = this.name;
        if (!this.nameIsCapturing || name == null || lineText == null || captureIndices == null) {
            return name;
        }
        return RegexSource.replaceCaptures(name, lineText, captureIndices);
    }

    public @Nullable String getContentName(CharSequence lineText, OnigCaptureIndex[] captureIndices) {
        String contentName = this.contentName;
        if (!this.contentNameIsCapturing || contentName == null) {
            return contentName;
        }
        return RegexSource.replaceCaptures(contentName, lineText, captureIndices);
    }

    public abstract void collectPatterns(IRuleRegistry var1, RegExpSourceList var2);

    public abstract CompiledRule compile(IRuleRegistry var1, @Nullable String var2);

    public abstract CompiledRule compileAG(IRuleRegistry var1, @Nullable String var2, boolean var3, boolean var4);
}

